# Shortest Path Using Atmost One Curved Edge
## Hard
<div class="problems_problem_content__Xm_eO"><p><span style="font-size:18px">Given an undirected connected graph of <strong>n</strong> vertices and list of <strong>m</strong> edges in a graph and for each pair of vertices that are connected by an edge.&nbsp;</span></p>

<p><span style="font-size:18px">There are two edges between them, one curved edge and one straight edge i.e. the tuple <strong>(x, y, w1, w2) </strong>means that between vertices <strong>x</strong> and <strong>y</strong>, there is a straight edge with weight <strong>w1</strong> and a curved edge with weight <strong>w2</strong>. </span></p>

<p><span style="font-size:18px">You are given two vertices <strong>a</strong> and <strong>b</strong> and you have to go from <strong>a</strong> to <strong>b</strong> through a series of edges such that in the entire path you can use at most 1 curved edge. Your task is to find the shortest path from <strong>a</strong> to <strong>b</strong> satisfying the above condition. If there is no path from a to b, return <strong>-1</strong>.</span></p>

<p>&nbsp;</p>

<p><span style="font-size:18px"><strong>Example 1:</strong></span></p>

<pre><span style="font-size:18px"><strong>Input:
</strong>n = 4, m = 4
a = 2, b = 4
edges = {{1, 2, 1, 4}, {1, 3, 2, 4},
         {1, 4, 3, 1}, {2, 4, 6, 5}}
<strong>Output:
</strong>2
</span><img src="data:image/png;base64,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"><span style="font-size:18px">
<strong>Explanation:</strong>
We can follow the path 2 -&gt; 1 -&gt; 4.</span>
<span style="font-size:18px">This gives a distance of 1+3 = 4 if we follow
all straight paths. But we can take the curved
path  from 1 -&gt; 4, which costs 1. This
will result in a cost of 1+1 = 2</span>
</pre>

<div><span style="font-size:18px"><strong>Example 2:</strong></span></div>

<pre><span style="font-size:18px"><strong>Input:
</strong>n = 2, m = 1
a = 1, b = 2
edges = {{1, 2, 4, 1}}
<strong>Output :</strong>
1
</span><img src="data:image/png;base64,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">
<span style="font-size:18px"><strong>Explanation:</strong>
Take the curved path from 1 to 2 which costs 1. </span>
</pre>

<p><br>
<span style="font-size:18px"><strong>Your Task:&nbsp;&nbsp;</strong><br>
You don't need to read input or print anything. Your task is to complete the function <strong>shortestPath()</strong>&nbsp;which takes 4 integers n, m, a, and b, and a list of lists named edges of size m as input and returns the cost of shortest path from a to b.</span></p>

<p><br>
<span style="font-size:18px"><strong>Expected Time Complexity:</strong> O((m+n)log(n))<br>
<strong>Expected Auxiliary Space:</strong> O(n+m)</span></p>

<p><br>
<span style="font-size:18px"><strong>Constraints:</strong><br>
1 ≤ n,m ≤ 10<sup>5</sup><br>
1 ≤ a,b ≤ n<br>
weight of edges ≤ 10<sup>4</sup></span></p>
</div>